/*
 * Decompiled with CFR 0.152.
 */
package ch.security4web.esapi.authentication;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.faces.component.FacesComponent;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.owasp.esapi.Authenticator;
import org.owasp.esapi.User;
import org.owasp.esapi.reference.FileBasedAuthenticator;

@FacesComponent(value="esapiAuthorization")
public class EsapiAuthorization
extends UIOutput {
    private String role;
    private static List<UIComponent> children;

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.role};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.role = (String)values[1];
    }

    public String getFamily() {
        return "esapi.authorization";
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        Authenticator authenticator = FileBasedAuthenticator.getInstance();
        User user = authenticator.getCurrentUser();
        if (user != null) {
            System.out.println("***User Name :" + user.getAccountName());
            User fileBaseUser = authenticator.getUser(user.getAccountName());
            if (fileBaseUser != null) {
                Set roles = fileBaseUser.getRoles();
                boolean roleFlag = false;
                Set currentUserRoles = user.getRoles();
                for (String userRole : currentUserRoles) {
                    if (!roles.contains(userRole) || !roles.contains(this.role)) continue;
                    roleFlag = true;
                }
                if (!roleFlag) {
                    FacesContext facesContext = FacesContext.getCurrentInstance();
                    ExternalContext externalContext = facesContext.getExternalContext();
                    HttpServletRequest httpServletRequest = (HttpServletRequest)externalContext.getRequest();
                    HttpSession session = (HttpSession)externalContext.getSession(false);
                    LinkedList<String> blackList = (LinkedList<String>)session.getAttribute("blackList");
                    if (blackList == null) {
                        blackList = new LinkedList<String>();
                    }
                    System.out.println("*********************Enter to encodeBegin Function");
                    EsapiAuthorization.disableRec((UIComponent)this, blackList);
                    session.setAttribute("blackList", blackList);
                    System.out.println("*********************Length of blacklist" + session.getAttribute("blackList"));
                    List uiList = this.getChildren();
                    for (UIComponent uiComponent : uiList) {
                        this.getUIComponent(uiComponent);
                        uiComponent.setRendered(false);
                        uiComponent.setInView(false);
                    }
                }
            } else {
                throw new IOException("User is not stored in current session");
            }
        }
    }

    private void getUIComponent(UIComponent mainUIComponent) {
        for (UIComponent uiComponent : mainUIComponent.getChildren()) {
            if (uiComponent.getChildCount() > 0) {
                this.getUIComponent(uiComponent);
            }
            uiComponent.setInView(false);
        }
    }

    protected static void disableRec(UIComponent c, List<String> blackList) {
        System.out.println("disable" + c.getClientId());
        blackList.add(c.getClientId());
        children = c.getChildren();
        for (UIComponent child : children) {
            EsapiAuthorization.disableRec(child, blackList);
        }
    }
}

