/*
 * Decompiled with CFR 0.152.
 */
package ch.security4web.esapi.csrf;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

@WebFilter(servletNames={"facesServlet"})
public class OwaspCSRFSessionFilter
implements Filter {
    private FilterConfig fc;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.fc = filterConfig;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        System.out.println("**************Filter****************");
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        HttpSession session = httpServletRequest.getSession();
        System.out.println("***Filter Flag :" + session.getAttribute("FLAG"));
        String randomId = this.generateRandomId();
        System.out.println("**********Random key:" + randomId);
        session.setAttribute("CSRFTOKEN_NAME", (Object)randomId);
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    public void destroy() {
    }

    private String generateRandomId() {
        String hexToken = "";
        try {
            SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
            String randomNum = new Integer(sr.nextInt()).toString();
            MessageDigest sha = MessageDigest.getInstance("SHA-512");
            byte[] result = sha.digest(randomNum.getBytes());
            hexToken = OwaspCSRFSessionFilter.hexEncode(result);
        }
        catch (NoSuchAlgorithmException ex) {
            System.err.println(ex);
        }
        return hexToken;
    }

    private static String hexEncode(byte[] aInput) {
        StringBuilder result = new StringBuilder();
        char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        int idx = 0;
        while (idx < aInput.length) {
            byte b = aInput[idx];
            result.append(digits[(b & 0xF0) >> 4]);
            result.append(digits[b & 0xF]);
            ++idx;
        }
        return result.toString();
    }
}

