/*
 * Decompiled with CFR 0.152.
 */
package ch.security4web.esapi.csrf;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class OwaspCSRFSessionListener
implements HttpSessionListener {
    private static final String CSRFTOKEN_NAME = "CSRFTOKEN_NAME";

    public void sessionCreated(HttpSessionEvent event) {
        HttpSession session = event.getSession();
        String randomId = this.generateRandomId();
        session.setAttribute(CSRFTOKEN_NAME, (Object)randomId);
    }

    public void sessionDestroyed(HttpSessionEvent arg0) {
    }

    public String generateRandomId() {
        String hexToken = "";
        try {
            SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
            String randomNum = new Integer(sr.nextInt()).toString();
            MessageDigest sha = MessageDigest.getInstance("SHA-512");
            byte[] result = sha.digest(randomNum.getBytes());
            System.out.println("***Byte []" + result);
            hexToken = OwaspCSRFSessionListener.hexEncode(result);
            System.out.println("***hex Token" + hexToken);
        }
        catch (NoSuchAlgorithmException ex) {
            System.err.println(ex);
        }
        return hexToken;
    }

    private static String hexEncode(byte[] aInput) {
        StringBuilder result = new StringBuilder();
        char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        int idx = 0;
        while (idx < aInput.length) {
            byte b = aInput[idx];
            result.append(digits[(b & 0xF0) >> 4]);
            result.append(digits[b & 0xF]);
            ++idx;
        }
        return result.toString();
    }
}

