/*
 * Decompiled with CFR 0.152.
 */
package ch.security4web.esapi.csrf;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.FacesComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpSession;

@FacesComponent(value="owaspCsrfTokenComponent")
public class OwaspCSRFTokenInput
extends UIComponentBase {
    private static final String CSRFTOKEN_NAME = "CSRFTOKEN_NAME";

    public void encodeEnd(FacesContext context) throws IOException {
        HttpSession session = (HttpSession)context.getExternalContext().getSession(false);
        String token = (String)session.getAttribute(CSRFTOKEN_NAME);
        ResponseWriter responseWriter = context.getResponseWriter();
        responseWriter.startElement("input", null);
        responseWriter.writeAttribute("type", (Object)"hidden", null);
        responseWriter.writeAttribute("name", (Object)this.getClientId(context), "clientId");
        responseWriter.writeAttribute("value", (Object)token, CSRFTOKEN_NAME);
        responseWriter.endElement("input");
    }

    public void decode(FacesContext context) {
        String clientId = this.getClientId(context);
        ExternalContext external = context.getExternalContext();
        Map requestMap = external.getRequestParameterMap();
        String value = String.valueOf(requestMap.get(clientId));
        HttpSession session = (HttpSession)context.getExternalContext().getSession(false);
        String token = (String)session.getAttribute(CSRFTOKEN_NAME);
        if (value == null || "".equals(value)) {
            throw new RuntimeException("CSRFToken is missing!");
        }
        if (!value.equalsIgnoreCase(token)) {
            throw new RuntimeException("CSRFToken does not match!");
        }
    }

    public String getFamily() {
        return null;
    }
}

