/*
 * Decompiled with CFR 0.152.
 */
package ch.security4web.esapi.renderkit;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.component.html.HtmlInputText;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import org.apache.myfaces.shared.component.EscapeCapable;
import org.apache.myfaces.shared.renderkit.RendererUtils;
import org.apache.myfaces.shared.renderkit.html.CommonPropertyUtils;
import org.apache.myfaces.shared.renderkit.html.HTML;
import org.apache.myfaces.shared.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared.renderkit.html.HtmlTextRendererBase;
import org.apache.myfaces.shared.renderkit.html.util.JavascriptUtils;
import org.apache.myfaces.shared.renderkit.html.util.ResourceUtils;

public class EsapiTextRenderer
extends HtmlTextRendererBase {
    private static final Logger log = Logger.getLogger(HtmlTextRendererBase.class.getName());
    private static final String AUTOCOMPLETE_VALUE_OFF = "off";

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        FacesContext ctx = FacesContext.getCurrentInstance();
        String path = ctx.getExternalContext().getRequestContextPath();
        ResponseWriter writer = ctx.getResponseWriter();
        RendererUtils.checkParamValidity((FacesContext)facesContext, (UIComponent)component, null);
        Map behaviors = null;
        if (component instanceof ClientBehaviorHolder && !(behaviors = ((ClientBehaviorHolder)component).getClientBehaviors()).isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary((FacesContext)facesContext, (ResponseWriter)facesContext.getResponseWriter());
        }
        if (component instanceof UIInput) {
            this.renderInput(facesContext, component);
        } else if (component instanceof UIOutput) {
            this.renderOutput(facesContext, component);
        } else {
            throw new IllegalArgumentException("Unsupported component class " + component.getClass().getName());
        }
    }

    protected void renderOutput(FacesContext facesContext, UIComponent component) throws IOException {
        String text = RendererUtils.getStringValue((FacesContext)facesContext, (UIComponent)component);
        if (log.isLoggable(Level.FINE)) {
            log.fine("renderOutput '" + text + "'");
        }
        boolean escape = component instanceof HtmlOutputText || component instanceof EscapeCapable ? ((HtmlOutputText)component).isEscape() : RendererUtils.getBooleanAttribute((UIComponent)component, (String)"escape", (boolean)true);
        if (text != null) {
            ResponseWriter writer = facesContext.getResponseWriter();
            boolean span = false;
            if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                long commonPropertiesMarked = CommonPropertyUtils.getCommonPropertiesMarked((UIComponent)component);
                if ((commonPropertiesMarked & 0xFFFFFFFFFFFFFFDFL) > 0L) {
                    span = true;
                    writer.startElement("span", component);
                    HtmlRendererUtils.writeIdIfNecessary((ResponseWriter)writer, (UIComponent)component, (FacesContext)facesContext);
                } else if (CommonPropertyUtils.isIdRenderingNecessary((UIComponent)component)) {
                    span = true;
                    writer.startElement("span", component);
                    writer.writeAttribute("id", (Object)component.getClientId(facesContext), null);
                }
                CommonPropertyUtils.renderUniversalProperties((ResponseWriter)writer, (long)commonPropertiesMarked, (UIComponent)component);
                CommonPropertyUtils.renderStyleProperties((ResponseWriter)writer, (long)commonPropertiesMarked, (UIComponent)component);
                if (this.isRenderOutputEventAttributes()) {
                    HtmlRendererUtils.renderHTMLAttributes((ResponseWriter)writer, (UIComponent)component, (String[])HTML.EVENT_HANDLER_ATTRIBUTES);
                }
            } else if (component.getId() != null && !component.getId().startsWith("j_id")) {
                span = true;
                writer.startElement("span", component);
                HtmlRendererUtils.writeIdIfNecessary((ResponseWriter)writer, (UIComponent)component, (FacesContext)facesContext);
                HtmlRendererUtils.renderHTMLAttributes((ResponseWriter)writer, (UIComponent)component, (String[])HTML.COMMON_PASSTROUGH_ATTRIBUTES);
            } else {
                span = HtmlRendererUtils.renderHTMLAttributesWithOptionalStartElement((ResponseWriter)writer, (UIComponent)component, (String)"span", (String[])HTML.COMMON_PASSTROUGH_ATTRIBUTES);
            }
            if (escape) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("renderOutputText writing '" + text + "'");
                }
                writer.writeText((Object)text, "value");
            } else {
                writer.write(text);
            }
            if (span) {
                writer.endElement("span");
            }
        }
    }

    protected boolean isRenderOutputEventAttributes() {
        return true;
    }

    protected void renderInput(FacesContext facesContext, UIComponent component) throws IOException {
        this.renderInputBegin(facesContext, component);
        this.renderInputEnd(facesContext, component);
    }

    protected void renderInputBegin(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = component.getClientId(facesContext);
        String value = RendererUtils.getStringValue((FacesContext)facesContext, (UIComponent)component);
        if (log.isLoggable(Level.FINE)) {
            log.fine("renderInput '" + value + "'");
        }
        writer.startElement("input", component);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        String inputHtmlType = this.getInputHtmlType(component);
        writer.writeAttribute("type", (Object)inputHtmlType, null);
        if (value != null) {
            writer.writeAttribute("value", (Object)value, "value");
        }
        Map behaviors = null;
        if (component instanceof ClientBehaviorHolder && JavascriptUtils.isJavascriptAllowed((ExternalContext)facesContext.getExternalContext())) {
            behaviors = ((ClientBehaviorHolder)component).getClientBehaviors();
            HtmlRendererUtils.renderBehaviorizedOnchangeEventHandler((FacesContext)facesContext, (ResponseWriter)writer, (UIComponent)component, (Map)behaviors);
            HtmlRendererUtils.renderBehaviorizedEventHandlers((FacesContext)facesContext, (ResponseWriter)writer, (UIComponent)component, (Map)behaviors);
            HtmlRendererUtils.renderBehaviorizedFieldEventHandlersWithoutOnchange((FacesContext)facesContext, (ResponseWriter)writer, (UIComponent)component, (Map)behaviors);
            if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                CommonPropertyUtils.renderInputPassthroughPropertiesWithoutDisabledAndEvents((ResponseWriter)writer, (long)CommonPropertyUtils.getCommonPropertiesMarked((UIComponent)component), (UIComponent)component);
            } else {
                HtmlRendererUtils.renderHTMLAttributes((ResponseWriter)writer, (UIComponent)component, (String[])HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_EVENTS);
            }
        } else if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
            CommonPropertyUtils.renderInputPassthroughPropertiesWithoutDisabled((ResponseWriter)writer, (long)CommonPropertyUtils.getCommonPropertiesMarked((UIComponent)component), (UIComponent)component);
        } else {
            HtmlRendererUtils.renderHTMLAttributes((ResponseWriter)writer, (UIComponent)component, (String[])HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
        }
        if (this.isDisabled(facesContext, component)) {
            writer.writeAttribute("disabled", (Object)Boolean.TRUE, null);
        }
        if (this.isAutocompleteOff(facesContext, component)) {
            writer.writeAttribute("autocomplete", (Object)AUTOCOMPLETE_VALUE_OFF, "autocomplete");
        }
    }

    protected void renderInputEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.endElement("input");
    }

    protected boolean isDisabled(FacesContext facesContext, UIComponent component) {
        if (component instanceof HtmlInputText) {
            return ((HtmlInputText)component).isDisabled();
        }
        return RendererUtils.getBooleanAttribute((UIComponent)component, (String)"disabled", (boolean)false);
    }

    protected boolean isAutocompleteOff(FacesContext facesContext, UIComponent component) {
        String autocomplete;
        if (component instanceof HtmlInputText && (autocomplete = ((HtmlInputText)component).getAutocomplete()) != null) {
            return autocomplete.equals(AUTOCOMPLETE_VALUE_OFF);
        }
        return false;
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        RendererUtils.checkParamValidity((FacesContext)facesContext, (UIComponent)component, null);
        if (component instanceof UIInput) {
            HtmlRendererUtils.decodeUIInput((FacesContext)facesContext, (UIComponent)component);
            if (component instanceof ClientBehaviorHolder && !HtmlRendererUtils.isDisabled((UIComponent)component)) {
                HtmlRendererUtils.decodeClientBehaviors((FacesContext)facesContext, (UIComponent)component);
            }
        } else if (!(component instanceof UIOutput)) {
            throw new IllegalArgumentException("Unsupported component class " + component.getClass().getName());
        }
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent component, Object submittedValue) throws ConverterException {
        RendererUtils.checkParamValidity((FacesContext)facesContext, (UIComponent)component, UIOutput.class);
        return RendererUtils.getConvertedUIOutputValue((FacesContext)facesContext, (UIOutput)((UIOutput)component), (Object)submittedValue);
    }

    protected String getInputHtmlType(UIComponent component) {
        return "text";
    }

    public static void renderOutputText(FacesContext facesContext, UIComponent component, String text, boolean escape) throws IOException {
        if (text != null) {
            ResponseWriter writer = facesContext.getResponseWriter();
            boolean span = false;
            if (component.getId() != null && !component.getId().startsWith("j_id")) {
                span = true;
                writer.startElement("span", component);
                HtmlRendererUtils.writeIdIfNecessary((ResponseWriter)writer, (UIComponent)component, (FacesContext)facesContext);
                HtmlRendererUtils.renderHTMLAttributes((ResponseWriter)writer, (UIComponent)component, (String[])HTML.COMMON_PASSTROUGH_ATTRIBUTES);
            } else {
                span = HtmlRendererUtils.renderHTMLAttributesWithOptionalStartElement((ResponseWriter)writer, (UIComponent)component, (String)"span", (String[])HTML.COMMON_PASSTROUGH_ATTRIBUTES);
            }
            if (escape) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("renderOutputText writing '" + text + "'");
                }
                writer.writeText((Object)text, "value");
            } else {
                writer.write(text);
            }
            if (span) {
                writer.endElement("span");
            }
        }
    }
}

