/*
 * Decompiled with CFR 0.152.
 */
package ch.security4web.esapi.testing;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class CSRFSessionListener
implements HttpSessionListener {
    private static final String CSRFTOKEN_NAME = "CSRFTOKEN_NAME_FOR_APP";

    public void sessionCreated(HttpSessionEvent event) {
        HttpSession session = event.getSession();
        String randomId = this.generateRandomId();
        session.setAttribute(CSRFTOKEN_NAME, (Object)randomId);
    }

    public void sessionDestroyed(HttpSessionEvent se) {
    }

    public String generateRandomId() {
        SecureRandom random = null;
        byte[] randomDigest = null;
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
            MessageDigest sha = MessageDigest.getInstance("SHA-1");
            randomDigest = sha.digest(new Integer(random.nextInt()).toString().getBytes());
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(CSRFSessionListener.class.getName()).log(Level.SEVERE, "NoSuchAlgorithmException", ex);
        }
        Logger.getLogger(CSRFSessionListener.class.getName()).log(Level.FINEST, "Random Digest for session: {0}", CSRFSessionListener.hexEncode(randomDigest));
        return CSRFSessionListener.hexEncode(randomDigest);
    }

    private static String hexEncode(byte[] aInput) {
        StringBuilder result = new StringBuilder();
        char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        int idx = 0;
        while (idx < aInput.length) {
            byte b = aInput[idx];
            result.append(digits[(b & 0xF0) >> 4]);
            result.append(digits[b & 0xF]);
            ++idx;
        }
        return result.toString();
    }
}

