/*
 * Decompiled with CFR 0.152.
 */
package ch.security4web.esapi.testing;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.FacesComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpSession;

@FacesComponent(value="CSRFTokenInput")
public class CSRFTokenInput
extends UIComponentBase {
    private static final String CSRFTOKEN_NAME = "CSRFTOKEN_NAME_FOR_APP";

    public String getFamily() {
        return "csrfpt";
    }

    public void encodeEnd(FacesContext context) throws IOException {
        Logger.getLogger(CSRFTokenInput.class.getName()).log(Level.INFO, "Enter encodeEnd");
        HttpSession session = (HttpSession)context.getExternalContext().getSession(false);
        String token = (String)session.getAttribute(CSRFTOKEN_NAME);
        ResponseWriter responseWriter = context.getResponseWriter();
        responseWriter.startElement("input", null);
        responseWriter.writeAttribute("type", (Object)"hidden", null);
        responseWriter.writeAttribute("name", (Object)this.getClientId(context), "clientId");
        responseWriter.writeAttribute("value", (Object)token, "CSRFTOKEN_NAME");
        responseWriter.endElement("input");
        Logger.getLogger(CSRFTokenInput.class.getName()).log(Level.INFO, "CSRFTokenEncode Token: {0}", token);
    }

    public void decode(FacesContext context) {
        Logger.getLogger(CSRFTokenInput.class.getName()).log(Level.FINEST, "Enter Decode");
        String clientId = this.getClientId(context);
        ExternalContext external = context.getExternalContext();
        Map requestMap = external.getRequestParameterMap();
        Logger.getLogger(CSRFTokenInput.class.getName()).log(Level.FINEST, "ClientId {0}", clientId);
        String value = String.valueOf(requestMap.get(clientId));
        Logger.getLogger(CSRFTokenInput.class.getName()).log(Level.FINEST, "CSRFTokenDecode Token: {0}", value);
        HttpSession session = (HttpSession)context.getExternalContext().getSession(false);
        String token = (String)session.getAttribute(CSRFTOKEN_NAME);
        if (!value.equalsIgnoreCase(token)) {
            Logger.getLogger(CSRFTokenInput.class.getName()).log(Level.SEVERE, "CSRFToken does not match!");
            throw new RuntimeException("CSRFToken does not match!");
        }
        if (value == null || "".equals(value)) {
            Logger.getLogger(CSRFTokenInput.class.getName()).log(Level.SEVERE, "CSRFToken is missing!");
            throw new RuntimeException("CSRFToken is missing!");
        }
    }
}

