/*
 * Decompiled with CFR 0.152.
 */
package ch.security4web.esapi.testing;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Encoder;
import org.owasp.esapi.ValidationErrorList;
import org.owasp.esapi.ValidationRule;
import org.owasp.esapi.Validator;
import org.owasp.esapi.errors.ValidationException;
import org.owasp.esapi.reference.DefaultEncoder;
import org.owasp.esapi.reference.DefaultValidator;
import org.owasp.esapi.reference.validation.HTMLValidationRule;
import org.owasp.esapi.reference.validation.StringValidationRule;

public class EsapiValidationTest
extends TestCase {
    private static final String PREFERRED_ENCODING = "UTF-8";

    public static Test suite() {
        return new TestSuite(EsapiValidationTest.class);
    }

    public EsapiValidationTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public void testAddRule() {
        Validator validator = ESAPI.validator();
        StringValidationRule rule = new StringValidationRule("ridiculous");
        validator.addRule((ValidationRule)rule);
        EsapiValidationTest.assertEquals((Object)rule, (Object)validator.getRule("ridiculous"));
    }

    public void testAssertValidFileUpload() {
    }

    public void testGetPrintable1() {
    }

    public void testGetPrintable2() {
    }

    public void testGetRule() {
        Validator validator = ESAPI.validator();
        StringValidationRule rule = new StringValidationRule("rule");
        validator.addRule((ValidationRule)rule);
        EsapiValidationTest.assertEquals((Object)rule, (Object)validator.getRule("rule"));
        EsapiValidationTest.assertFalse((rule == validator.getRule("ridiculous") ? 1 : 0) != 0);
    }

    public void testGetValidCreditCard() {
        System.out.println("getValidCreditCard");
        Validator instance = ESAPI.validator();
        ValidationErrorList errors = new ValidationErrorList();
        System.out.println(instance.isValidCreditCard("cctest1", "1234 9876 0000 0008", false));
        System.out.println(instance.isValidCreditCard("cctest2", "1234987600000008", false));
        System.out.println(instance.isValidCreditCard("cctest3", "12349876000000081", false));
        System.out.println(instance.isValidCreditCard("cctest4", "4417 1234 5678 9112", false));
        EsapiValidationTest.assertTrue((boolean)instance.isValidCreditCard("cctest1", "1234 9876 0000 0008", false));
        EsapiValidationTest.assertTrue((boolean)instance.isValidCreditCard("cctest2", "1234987600000008", false));
        EsapiValidationTest.assertFalse((boolean)instance.isValidCreditCard("cctest3", "12349876000000081", false));
        EsapiValidationTest.assertFalse((boolean)instance.isValidCreditCard("cctest4", "4417 1234 5678 9112", false));
        System.out.println(instance.getValidCreditCard("cctest5", "1234 9876 0000 0008", false, errors));
        System.out.println(instance.getValidCreditCard("cctest6", "1234987600000008", false, errors));
        System.out.println(instance.getValidCreditCard("cctest7", "12349876000000081", false, errors));
        System.out.println(instance.getValidCreditCard("cctest8", "4417 1234 5678 9112", false, errors));
        instance.getValidCreditCard("cctest5", "1234 9876 0000 0008", false, errors);
        EsapiValidationTest.assertEquals((int)0, (int)errors.size());
        instance.getValidCreditCard("cctest6", "1234987600000008", false, errors);
        EsapiValidationTest.assertEquals((int)0, (int)errors.size());
        instance.getValidCreditCard("cctest7", "12349876000000081", false, errors);
        EsapiValidationTest.assertEquals((int)1, (int)errors.size());
        instance.getValidCreditCard("cctest8", "4417 1234 5678 9112", false, errors);
        EsapiValidationTest.assertEquals((int)2, (int)errors.size());
        EsapiValidationTest.assertTrue((boolean)instance.isValidCreditCard("cctest1", "1234 9876 0000 0008", false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 2 ? 1 : 0) != 0);
        EsapiValidationTest.assertTrue((boolean)instance.isValidCreditCard("cctest2", "1234987600000008", false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 2 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidCreditCard("cctest3", "12349876000000081", false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 3 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidCreditCard("cctest4", "4417 1234 5678 9112", false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 4 ? 1 : 0) != 0);
    }

    public void testGetValidDate() throws Exception {
        System.out.println("getValidDate");
        Validator instance = ESAPI.validator();
        ValidationErrorList errors = new ValidationErrorList();
        EsapiValidationTest.assertTrue((instance.getValidDate("datetest1", "June 23, 1967", DateFormat.getDateInstance(2, Locale.US), false) != null ? 1 : 0) != 0);
        instance.getValidDate("datetest2", "freakshow", DateFormat.getDateInstance(), false, errors);
        EsapiValidationTest.assertEquals((int)1, (int)errors.size());
        instance.getValidDate("test", "June 32, 2008", DateFormat.getDateInstance(), false, errors);
    }

    public void testLenientDate() {
        System.out.println("testLenientDate");
        boolean acceptLenientDates = ESAPI.securityConfiguration().getLenientDatesAccepted();
        if (acceptLenientDates) {
            EsapiValidationTest.assertTrue((String)"Lenient date test skipped because Validator.AcceptLenientDates set to true", (boolean)true);
            return;
        }
        Date lenientDateTest = null;
        try {
            Validator instance = ESAPI.validator();
            lenientDateTest = instance.getValidDate("datatest3-lenient", "15/2/2009 11:83:00", DateFormat.getDateInstance(3, Locale.US), false);
            EsapiValidationTest.fail((String)"Failed to throw expected ValidationException when Validator.AcceptLenientDates set to false.");
        }
        catch (ValidationException ve) {
            EsapiValidationTest.assertNull(lenientDateTest);
            Throwable cause = ve.getCause();
            EsapiValidationTest.assertTrue((boolean)cause.getClass().getName().equals("java.text.ParseException"));
        }
        catch (Exception e) {
            EsapiValidationTest.fail((String)("Caught unexpected exception: " + e.getClass().getName() + "; msg: " + e));
        }
    }

    public void testGetValidDirectoryPath() throws Exception {
        System.out.println("getValidDirectoryPath");
        Validator instance = ESAPI.validator();
        ValidationErrorList errors = new ValidationErrorList();
        File parent = new File("/");
        String path = ESAPI.securityConfiguration().getResourceFile("ESAPI.properties").getParentFile().getCanonicalPath();
        instance.getValidDirectoryPath("dirtest1", path, parent, true, errors);
        EsapiValidationTest.assertEquals((int)0, (int)errors.size());
        instance.getValidDirectoryPath("dirtest2", null, parent, false, errors);
        EsapiValidationTest.assertEquals((int)1, (int)errors.size());
        instance.getValidDirectoryPath("dirtest3", "ridicul%00ous", parent, false, errors);
        EsapiValidationTest.assertEquals((int)2, (int)errors.size());
    }

    public void testGetValidDouble() {
        System.out.println("getValidDouble");
        Validator instance = ESAPI.validator();
        ValidationErrorList errors = new ValidationErrorList();
        instance.getValidDouble("dtest1", "1.0", 0.0, 20.0, true, errors);
        EsapiValidationTest.assertEquals((int)0, (int)errors.size());
        instance.getValidDouble("dtest2", null, 0.0, 20.0, true, errors);
        EsapiValidationTest.assertEquals((int)0, (int)errors.size());
        instance.getValidDouble("dtest3", null, 0.0, 20.0, false, errors);
        EsapiValidationTest.assertEquals((int)1, (int)errors.size());
        instance.getValidDouble("dtest4", "ridiculous", 0.0, 20.0, true, errors);
        EsapiValidationTest.assertEquals((int)2, (int)errors.size());
        instance.getValidDouble("dtest5", "1.7976931348623157E308", 0.0, 20.0, true, errors);
        EsapiValidationTest.assertEquals((int)3, (int)errors.size());
        instance.getValidDouble("dtest6", "1.7976931348623157E308", 0.0, 20.0, true, errors);
        EsapiValidationTest.assertEquals((int)4, (int)errors.size());
    }

    public void testGetValidFileContent() {
        System.out.println("getValidFileContent");
        Validator instance = ESAPI.validator();
        ValidationErrorList errors = new ValidationErrorList();
        byte[] bytes = null;
        try {
            bytes = "12345".getBytes(PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            EsapiValidationTest.fail((String)"UTF-8 not a supported encoding?!?!!");
        }
        instance.getValidFileContent("test", bytes, 5, true, errors);
        EsapiValidationTest.assertEquals((int)0, (int)errors.size());
        instance.getValidFileContent("test", bytes, 4, true, errors);
        EsapiValidationTest.assertEquals((int)1, (int)errors.size());
    }

    public void testGetValidFileName() throws Exception {
        System.out.println("getValidFileName");
        Validator instance = ESAPI.validator();
        ValidationErrorList errors = new ValidationErrorList();
        String testName = "aspe%20ct.jar";
        EsapiValidationTest.assertEquals((String)"Percent encoding is not changed", (String)testName, (String)instance.getValidFileName("test", testName, ESAPI.securityConfiguration().getAllowedFileExtensions(), false, errors));
    }

    public void testGetValidInput() {
        System.out.println("getValidInput");
        Validator instance = ESAPI.validator();
        ValidationErrorList errors = new ValidationErrorList();
    }

    public void testGetValidInteger() {
        System.out.println("getValidInteger");
        Validator instance = ESAPI.validator();
        ValidationErrorList errors = new ValidationErrorList();
    }

    public void testGetValidListItem() {
        System.out.println("getValidListItem");
        Validator instance = ESAPI.validator();
        ValidationErrorList errors = new ValidationErrorList();
    }

    public void testGetValidNumber() {
        System.out.println("getValidNumber");
        Validator instance = ESAPI.validator();
        ValidationErrorList errors = new ValidationErrorList();
    }

    public void testGetValidRedirectLocation() {
        System.out.println("getValidRedirectLocation");
        Validator instance = ESAPI.validator();
        ValidationErrorList errors = new ValidationErrorList();
    }

    public void testGetValidSafeHTML() throws Exception {
        System.out.println("getValidSafeHTML");
        Validator instance = ESAPI.validator();
        ValidationErrorList errors = new ValidationErrorList();
        HTMLValidationRule rule = new HTMLValidationRule("test");
        ESAPI.validator().addRule((ValidationRule)rule);
        EsapiValidationTest.assertEquals((Object)"Test.", (Object)ESAPI.validator().getRule("test").getValid("test", "Test. <script>alert(document.cookie)</script>"));
        String test1 = "<b>Jeff</b>";
        String result1 = instance.getValidSafeHTML("test", test1, 100, false, errors);
        EsapiValidationTest.assertEquals((String)test1, (String)result1);
        String test2 = "<a href=\"http://www.aspectsecurity.com\">Aspect Security</a>";
        String result2 = instance.getValidSafeHTML("test", test2, 100, false, errors);
        String test3 = "Test. <script>alert(document.cookie)</script>";
        EsapiValidationTest.assertEquals((Object)"Test.", (Object)rule.getSafe("test", test3));
        System.out.println("********** Validation :" + rule.getSafe("test", "Test. <<div on<script></script>load=alert()"));
        System.out.println("********** Validation :" + instance.getValidSafeHTML("test", "Test. <<div on<script></script>load=alert()", 100, false, errors));
        System.out.println("********** Validation :" + rule.getSafe("test", "Test. <div style={xss:expression(xss)}>b</div>"));
        System.out.println("********** Validation :" + instance.getValidSafeHTML("test", "Test. <div style={xss:expression(xss)}>b</div>", 100, false, errors));
        System.out.println("********** Validation :" + rule.getSafe("test", "Test. <s%00cript>alert(document.cookie)</script>"));
        System.out.println("********** Validation :" + instance.getValidSafeHTML("test", "Test. <s%00cript>alert(document.cookie)</script>", 100, false, errors));
        System.out.println("********** Validation :" + rule.getSafe("test", "Test. <s\tcript>alert(document.cookie)</script>"));
        System.out.println("********** Validation :" + instance.getValidSafeHTML("test", "Test. <s\tcript>alert(document.cookie)</script>", 100, false, errors));
        System.out.println("********** Validation :" + rule.getSafe("test", "Test. <s\tcript>alert(document.cookie)</script>"));
        System.out.println("********** Validation :" + instance.getValidSafeHTML("test", "Test. <s\tcript>alert(document.cookie)</script>", 100, false, errors));
        EsapiValidationTest.assertEquals((Object)"Test. &lt;<div>load=alert()</div>", (Object)rule.getSafe("test", "Test. <<div on<script></script>load=alert()"));
        EsapiValidationTest.assertEquals((Object)"Test. <div>b</div>", (Object)rule.getSafe("test", "Test. <div style={xss:expression(xss)}>b</div>"));
        EsapiValidationTest.assertEquals((Object)"Test.", (Object)rule.getSafe("test", "Test. <s%00cript>alert(document.cookie)</script>"));
        EsapiValidationTest.assertEquals((Object)"Test. alert(document.cookie)", (Object)rule.getSafe("test", "Test. <s\tcript>alert(document.cookie)</script>"));
        EsapiValidationTest.assertEquals((Object)"Test. alert(document.cookie)", (Object)rule.getSafe("test", "Test. <s\tcript>alert(document.cookie)</script>"));
        HTMLValidationRule rule1 = new HTMLValidationRule("test1");
        ESAPI.validator().addRule((ValidationRule)rule1);
        String result = (String)ESAPI.validator().getRule("test1").getValid("test1", "test1");
        System.out.println("***********Result :" + result);
    }

    public void testIsInvalidFilename() {
        System.out.println("testIsInvalidFilename");
        Validator instance = ESAPI.validator();
        char[] invalidChars = "/\\:*?\"<>|".toCharArray();
        int i = 0;
        while (i < invalidChars.length) {
            EsapiValidationTest.assertFalse((String)(String.valueOf(invalidChars[i]) + " is an invalid character for a filename"), (boolean)instance.isValidFileName("test", "as" + invalidChars[i] + "pect.jar", false));
            ++i;
        }
        EsapiValidationTest.assertFalse((String)"Files must have an extension", (boolean)instance.isValidFileName("test", "", false));
        EsapiValidationTest.assertFalse((String)"Files must have a valid extension", (boolean)instance.isValidFileName("test.invalidExtension", "", false));
        EsapiValidationTest.assertFalse((String)"Filennames cannot be the empty string", (boolean)instance.isValidFileName("test", "", false));
    }

    public void testIsValidDate() {
        System.out.println("isValidDate");
        Validator instance = ESAPI.validator();
        DateFormat format = SimpleDateFormat.getDateInstance();
        EsapiValidationTest.assertTrue((boolean)instance.isValidDate("datetest1", "September 11, 2001", format, true));
        EsapiValidationTest.assertFalse((boolean)instance.isValidDate("datetest2", null, format, false));
        EsapiValidationTest.assertFalse((boolean)instance.isValidDate("datetest3", "", format, false));
        ValidationErrorList errors = new ValidationErrorList();
        EsapiValidationTest.assertTrue((boolean)instance.isValidDate("datetest1", "September 11, 2001", format, true, errors));
        EsapiValidationTest.assertTrue((errors.size() == 0 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidDate("datetest2", null, format, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidDate("datetest3", "", format, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 2 ? 1 : 0) != 0);
    }

    public void testIsValidDirectoryPath() throws IOException {
        System.out.println("isValidDirectoryPath");
        ArrayList<String> list = new ArrayList<String>();
        list.add("HTMLEntityCodec");
        DefaultEncoder encoder = new DefaultEncoder(list);
        DefaultValidator instance = new DefaultValidator((Encoder)encoder);
        boolean isWindows = System.getProperty("os.name").indexOf("Windows") != -1;
        File parent = new File("/");
        ValidationErrorList errors = new ValidationErrorList();
        if (isWindows) {
            String sysRoot = new File(System.getenv("SystemRoot")).getCanonicalPath();
            EsapiValidationTest.assertFalse((boolean)instance.isValidDirectoryPath("test", "c:\\ridiculous", parent, false));
            EsapiValidationTest.assertFalse((boolean)instance.isValidDirectoryPath("test", "c:\\jeff", parent, false));
            EsapiValidationTest.assertFalse((boolean)instance.isValidDirectoryPath("test", "c:\\temp\\..\\etc", parent, false));
            EsapiValidationTest.assertTrue((boolean)instance.isValidDirectoryPath("test", "C:\\", parent, false));
            EsapiValidationTest.assertTrue((boolean)instance.isValidDirectoryPath("test", sysRoot, parent, false));
            EsapiValidationTest.assertFalse((boolean)instance.isValidDirectoryPath("test", String.valueOf(sysRoot) + "\\System32\\cmd.exe", parent, false));
            EsapiValidationTest.assertFalse((boolean)instance.isValidDirectoryPath("test", "/tmp", parent, false));
            EsapiValidationTest.assertFalse((boolean)instance.isValidDirectoryPath("test", "/bin/sh", parent, false));
            EsapiValidationTest.assertFalse((boolean)instance.isValidDirectoryPath("test", "/etc/config", parent, false));
            EsapiValidationTest.assertFalse((boolean)instance.isValidDirectoryPath("test", "/etc/ridiculous", parent, false));
            EsapiValidationTest.assertFalse((boolean)instance.isValidDirectoryPath("test", "/tmp/../etc", parent, false));
            EsapiValidationTest.assertFalse((boolean)instance.isValidDirectoryPath("test1", "c:\\ridiculous", parent, false, errors));
            EsapiValidationTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
            EsapiValidationTest.assertFalse((boolean)instance.isValidDirectoryPath("test2", "c:\\jeff", parent, false, errors));
            EsapiValidationTest.assertTrue((errors.size() == 2 ? 1 : 0) != 0);
            EsapiValidationTest.assertFalse((boolean)instance.isValidDirectoryPath("test3", "c:\\temp\\..\\etc", parent, false, errors));
            EsapiValidationTest.assertTrue((errors.size() == 3 ? 1 : 0) != 0);
            EsapiValidationTest.assertTrue((boolean)instance.isValidDirectoryPath("test4", "C:\\", parent, false, errors));
            EsapiValidationTest.assertTrue((errors.size() == 3 ? 1 : 0) != 0);
            EsapiValidationTest.assertTrue((boolean)instance.isValidDirectoryPath("test5", sysRoot, parent, false, errors));
            EsapiValidationTest.assertTrue((errors.size() == 3 ? 1 : 0) != 0);
            EsapiValidationTest.assertFalse((boolean)instance.isValidDirectoryPath("test6", String.valueOf(sysRoot) + "\\System32\\cmd.exe", parent, false, errors));
            EsapiValidationTest.assertTrue((errors.size() == 4 ? 1 : 0) != 0);
            EsapiValidationTest.assertFalse((boolean)instance.isValidDirectoryPath("test7", "/tmp", parent, false, errors));
            EsapiValidationTest.assertTrue((errors.size() == 5 ? 1 : 0) != 0);
            EsapiValidationTest.assertFalse((boolean)instance.isValidDirectoryPath("test8", "/bin/sh", parent, false, errors));
            EsapiValidationTest.assertTrue((errors.size() == 6 ? 1 : 0) != 0);
            EsapiValidationTest.assertFalse((boolean)instance.isValidDirectoryPath("test9", "/etc/config", parent, false, errors));
            EsapiValidationTest.assertTrue((errors.size() == 7 ? 1 : 0) != 0);
            EsapiValidationTest.assertFalse((boolean)instance.isValidDirectoryPath("test10", "/etc/ridiculous", parent, false, errors));
            EsapiValidationTest.assertTrue((errors.size() == 8 ? 1 : 0) != 0);
            EsapiValidationTest.assertFalse((boolean)instance.isValidDirectoryPath("test11", "/tmp/../etc", parent, false, errors));
            EsapiValidationTest.assertTrue((errors.size() == 9 ? 1 : 0) != 0);
        } else {
            EsapiValidationTest.assertFalse((boolean)instance.isValidDirectoryPath("test", "c:\\ridiculous", parent, false));
            EsapiValidationTest.assertFalse((boolean)instance.isValidDirectoryPath("test", "c:\\temp\\..\\etc", parent, false));
            EsapiValidationTest.assertFalse((boolean)instance.isValidDirectoryPath("test", "c:\\", parent, false));
            EsapiValidationTest.assertFalse((boolean)instance.isValidDirectoryPath("test", "c:\\Windows\\temp", parent, false));
            EsapiValidationTest.assertFalse((boolean)instance.isValidDirectoryPath("test", "c:\\Windows\\System32\\cmd.exe", parent, false));
            EsapiValidationTest.assertTrue((boolean)instance.isValidDirectoryPath("test", "/", parent, false));
            EsapiValidationTest.assertTrue((boolean)instance.isValidDirectoryPath("test", "/bin", parent, false));
            EsapiValidationTest.assertFalse((boolean)instance.isValidDirectoryPath("test", "/bin/sh", parent, false));
            EsapiValidationTest.assertFalse((boolean)instance.isValidDirectoryPath("test", "/etc/ridiculous", parent, false));
            EsapiValidationTest.assertFalse((boolean)instance.isValidDirectoryPath("test", "/tmp/../etc", parent, false));
            EsapiValidationTest.assertFalse((boolean)instance.isValidDirectoryPath("test1", "c:\\ridiculous", parent, false, errors));
            EsapiValidationTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
            EsapiValidationTest.assertFalse((boolean)instance.isValidDirectoryPath("test2", "c:\\temp\\..\\etc", parent, false, errors));
            EsapiValidationTest.assertTrue((errors.size() == 2 ? 1 : 0) != 0);
            EsapiValidationTest.assertFalse((boolean)instance.isValidDirectoryPath("test3", "c:\\", parent, false, errors));
            EsapiValidationTest.assertTrue((errors.size() == 3 ? 1 : 0) != 0);
            EsapiValidationTest.assertFalse((boolean)instance.isValidDirectoryPath("test4", "c:\\Windows\\temp", parent, false, errors));
            EsapiValidationTest.assertTrue((errors.size() == 4 ? 1 : 0) != 0);
            EsapiValidationTest.assertFalse((boolean)instance.isValidDirectoryPath("test5", "c:\\Windows\\System32\\cmd.exe", parent, false, errors));
            EsapiValidationTest.assertTrue((errors.size() == 5 ? 1 : 0) != 0);
            EsapiValidationTest.assertTrue((boolean)instance.isValidDirectoryPath("test6", "/", parent, false, errors));
            EsapiValidationTest.assertTrue((errors.size() == 5 ? 1 : 0) != 0);
            EsapiValidationTest.assertTrue((boolean)instance.isValidDirectoryPath("test7", "/bin", parent, false, errors));
            EsapiValidationTest.assertTrue((errors.size() == 5 ? 1 : 0) != 0);
            EsapiValidationTest.assertFalse((boolean)instance.isValidDirectoryPath("test8", "/bin/sh", parent, false, errors));
            EsapiValidationTest.assertTrue((errors.size() == 6 ? 1 : 0) != 0);
            EsapiValidationTest.assertFalse((boolean)instance.isValidDirectoryPath("test9", "/etc/ridiculous", parent, false, errors));
            EsapiValidationTest.assertTrue((errors.size() == 7 ? 1 : 0) != 0);
            EsapiValidationTest.assertFalse((boolean)instance.isValidDirectoryPath("test10", "/tmp/../etc", parent, false, errors));
            EsapiValidationTest.assertTrue((errors.size() == 8 ? 1 : 0) != 0);
        }
    }

    public void TestIsValidDirectoryPath() {
    }

    public void testIsValidDouble() {
        Validator instance = ESAPI.validator();
        ValidationErrorList errors = new ValidationErrorList();
        EsapiValidationTest.assertFalse((boolean)instance.isValidDouble("test1", "-4", 1.0, 10.0, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        EsapiValidationTest.assertTrue((boolean)instance.isValidDouble("test2", "-4", -10.0, 10.0, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        EsapiValidationTest.assertTrue((boolean)instance.isValidDouble("test3", null, -10.0, 10.0, true, errors));
        EsapiValidationTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidDouble("test4", null, -10.0, 10.0, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 2 ? 1 : 0) != 0);
        EsapiValidationTest.assertTrue((boolean)instance.isValidDouble("test5", "", -10.0, 10.0, true, errors));
        EsapiValidationTest.assertTrue((errors.size() == 2 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidDouble("test6", "", -10.0, 10.0, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 3 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidDouble("test7", "50.0", 10.0, -10.0, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 4 ? 1 : 0) != 0);
        EsapiValidationTest.assertTrue((boolean)instance.isValidDouble("test8", "4.3214", -10.0, 10.0, true, errors));
        EsapiValidationTest.assertTrue((errors.size() == 4 ? 1 : 0) != 0);
        EsapiValidationTest.assertTrue((boolean)instance.isValidDouble("test9", "-1.65", -10.0, 10.0, true, errors));
        EsapiValidationTest.assertTrue((errors.size() == 4 ? 1 : 0) != 0);
        EsapiValidationTest.assertTrue((boolean)instance.isValidDouble("test10", "4", 1.0, 10.0, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 4 ? 1 : 0) != 0);
        EsapiValidationTest.assertTrue((boolean)instance.isValidDouble("test11", "400", 1.0, 10000.0, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 4 ? 1 : 0) != 0);
        EsapiValidationTest.assertTrue((boolean)instance.isValidDouble("test12", "400000000", 1.0, 4.0E8, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 4 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidDouble("test13", "4000000000000", 1.0, 10000.0, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 5 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidDouble("test14", "alsdkf", 10.0, 10000.0, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 6 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidDouble("test15", "--10", 10.0, 10000.0, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 7 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidDouble("test16", "14.1414234x", 10.0, 10000.0, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 8 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidDouble("test17", "Infinity", 10.0, 10000.0, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 9 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidDouble("test18", "-Infinity", 10.0, 10000.0, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 10 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidDouble("test19", "NaN", 10.0, 10000.0, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 11 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidDouble("test20", "-NaN", 10.0, 10000.0, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 12 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidDouble("test21", "+NaN", 10.0, 10000.0, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 13 ? 1 : 0) != 0);
        EsapiValidationTest.assertTrue((boolean)instance.isValidDouble("test22", "1e-6", -9.99999999E8, 9.99999999E8, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 13 ? 1 : 0) != 0);
        EsapiValidationTest.assertTrue((boolean)instance.isValidDouble("test23", "-1e-6", -9.99999999E8, 9.99999999E8, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 13 ? 1 : 0) != 0);
    }

    public void testIsValidFileContent() {
        System.out.println("isValidFileContent");
        byte[] content = null;
        try {
            content = "This is some file content".getBytes(PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            EsapiValidationTest.fail((String)"UTF-8 not a supported encoding?!?!!!");
        }
        Validator instance = ESAPI.validator();
        EsapiValidationTest.assertTrue((boolean)instance.isValidFileContent("test", content, 100, false));
    }

    public void testIsValidFileName() {
        System.out.println("isValidFileName");
        Validator instance = ESAPI.validator();
        EsapiValidationTest.assertTrue((String)"Simple valid filename with a valid extension", (boolean)instance.isValidFileName("test", "aspect.jar", false));
        EsapiValidationTest.assertTrue((String)"All valid filename characters are accepted", (boolean)instance.isValidFileName("test", "!@#$%^&{}[]()_+-=,.~'` abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890.jar", false));
        EsapiValidationTest.assertTrue((String)"Legal filenames that decode to legal filenames are accepted", (boolean)instance.isValidFileName("test", "aspe%20ct.jar", false));
        ValidationErrorList errors = new ValidationErrorList();
        EsapiValidationTest.assertTrue((String)"Simple valid filename with a valid extension", (boolean)instance.isValidFileName("test", "aspect.jar", false, errors));
        EsapiValidationTest.assertTrue((String)"All valid filename characters are accepted", (boolean)instance.isValidFileName("test", "!@#$%^&{}[]()_+-=,.~'` abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890.jar", false, errors));
        EsapiValidationTest.assertTrue((String)"Legal filenames that decode to legal filenames are accepted", (boolean)instance.isValidFileName("test", "aspe%20ct.jar", false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 0 ? 1 : 0) != 0);
    }

    public void testIsValidFileUpload() throws IOException {
        System.out.println("isValidFileUpload");
        String filepath = new File(System.getProperty("user.dir")).getCanonicalPath();
        String filename = "aspect.jar";
        File parent = new File("/").getCanonicalFile();
        ValidationErrorList errors = new ValidationErrorList();
        byte[] content = null;
        try {
            content = "This is some file content".getBytes(PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            EsapiValidationTest.fail((String)"UTF-8 not a supported encoding?!?!!!");
        }
        Validator instance = ESAPI.validator();
        EsapiValidationTest.assertTrue((boolean)instance.isValidFileUpload("test", filepath, filename, parent, content, 100, false));
        EsapiValidationTest.assertTrue((boolean)instance.isValidFileUpload("test", filepath, filename, parent, content, 100, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 0 ? 1 : 0) != 0);
        filepath = "/ridiculous";
        filename = "aspect.jar";
        try {
            content = "This is some file content".getBytes(PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            EsapiValidationTest.fail((String)"UTF-8 not a supported encoding?!?!!!");
        }
        EsapiValidationTest.assertFalse((boolean)instance.isValidFileUpload("test", filepath, filename, parent, content, 100, false));
        EsapiValidationTest.assertFalse((boolean)instance.isValidFileUpload("test", filepath, filename, parent, content, 100, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
    }

    public void testIsValidHTTPRequestParameterSet() {
    }

    public void testisValidInput() {
        System.out.println("isValidInput");
        Validator instance = ESAPI.validator();
        EsapiValidationTest.assertTrue((boolean)instance.isValidInput("test", "jeff.williams@aspectsecurity.com", "Email", 100, false));
        EsapiValidationTest.assertFalse((boolean)instance.isValidInput("test", "jeff.williams@@aspectsecurity.com", "Email", 100, false));
        EsapiValidationTest.assertFalse((boolean)instance.isValidInput("test", "jeff.williams@aspectsecurity", "Email", 100, false));
        EsapiValidationTest.assertTrue((boolean)instance.isValidInput("test", "jeff.wil'liams@aspectsecurity.com", "Email", 100, false));
        EsapiValidationTest.assertTrue((boolean)instance.isValidInput("test", "jeff.wil''liams@aspectsecurity.com", "Email", 100, false));
        EsapiValidationTest.assertTrue((boolean)instance.isValidInput("test", "123.168.100.234", "IPAddress", 100, false));
        EsapiValidationTest.assertTrue((boolean)instance.isValidInput("test", "192.168.1.234", "IPAddress", 100, false));
        EsapiValidationTest.assertFalse((boolean)instance.isValidInput("test", "..168.1.234", "IPAddress", 100, false));
        EsapiValidationTest.assertFalse((boolean)instance.isValidInput("test", "10.x.1.234", "IPAddress", 100, false));
        EsapiValidationTest.assertTrue((boolean)instance.isValidInput("test", "http://www.aspectsecurity.com", "URL", 100, false));
        EsapiValidationTest.assertFalse((boolean)instance.isValidInput("test", "http:///www.aspectsecurity.com", "URL", 100, false));
        EsapiValidationTest.assertFalse((boolean)instance.isValidInput("test", "http://www.aspect security.com", "URL", 100, false));
        EsapiValidationTest.assertTrue((boolean)instance.isValidInput("test", "078-05-1120", "SSN", 100, false));
        EsapiValidationTest.assertTrue((boolean)instance.isValidInput("test", "078 05 1120", "SSN", 100, false));
        EsapiValidationTest.assertTrue((boolean)instance.isValidInput("test", "078051120", "SSN", 100, false));
        EsapiValidationTest.assertFalse((boolean)instance.isValidInput("test", "987-65-4320", "SSN", 100, false));
        EsapiValidationTest.assertFalse((boolean)instance.isValidInput("test", "000-00-0000", "SSN", 100, false));
        EsapiValidationTest.assertFalse((boolean)instance.isValidInput("test", "(555) 555-5555", "SSN", 100, false));
        EsapiValidationTest.assertFalse((boolean)instance.isValidInput("test", "test", "SSN", 100, false));
        EsapiValidationTest.assertTrue((boolean)instance.isValidInput("test", "jeffWILLIAMS123", "HTTPParameterValue", 100, false));
        EsapiValidationTest.assertTrue((boolean)instance.isValidInput("test", "jeff .-/+=@_ WILLIAMS", "HTTPParameterValue", 100, false));
        EsapiValidationTest.assertFalse((boolean)instance.isValidInput("test", "jeff^WILLIAMS", "HTTPParameterValue", 100, false));
        EsapiValidationTest.assertFalse((boolean)instance.isValidInput("test", "jeff\\WILLIAMS", "HTTPParameterValue", 100, false));
        EsapiValidationTest.assertTrue((boolean)instance.isValidInput("test", null, "Email", 100, true));
        EsapiValidationTest.assertFalse((boolean)instance.isValidInput("test", null, "Email", 100, false));
        ValidationErrorList errors = new ValidationErrorList();
        EsapiValidationTest.assertTrue((boolean)instance.isValidInput("test1", "jeff.williams@aspectsecurity.com", "Email", 100, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 0 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidInput("test2", "jeff.williams@@aspectsecurity.com", "Email", 100, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidInput("test3", "jeff.williams@aspectsecurity", "Email", 100, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 2 ? 1 : 0) != 0);
        EsapiValidationTest.assertTrue((boolean)instance.isValidInput("test4", "jeff.wil'liams@aspectsecurity.com", "Email", 100, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 2 ? 1 : 0) != 0);
        EsapiValidationTest.assertTrue((boolean)instance.isValidInput("test5", "jeff.wil''liams@aspectsecurity.com", "Email", 100, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 2 ? 1 : 0) != 0);
        EsapiValidationTest.assertTrue((boolean)instance.isValidInput("test6", "123.168.100.234", "IPAddress", 100, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 2 ? 1 : 0) != 0);
        EsapiValidationTest.assertTrue((boolean)instance.isValidInput("test7", "192.168.1.234", "IPAddress", 100, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 2 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidInput("test8", "..168.1.234", "IPAddress", 100, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 3 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidInput("test9", "10.x.1.234", "IPAddress", 100, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 4 ? 1 : 0) != 0);
        EsapiValidationTest.assertTrue((boolean)instance.isValidInput("test10", "http://www.aspectsecurity.com", "URL", 100, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 4 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidInput("test11", "http:///www.aspectsecurity.com", "URL", 100, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 5 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidInput("test12", "http://www.aspect security.com", "URL", 100, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 6 ? 1 : 0) != 0);
        EsapiValidationTest.assertTrue((boolean)instance.isValidInput("test13", "078-05-1120", "SSN", 100, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 6 ? 1 : 0) != 0);
        EsapiValidationTest.assertTrue((boolean)instance.isValidInput("test14", "078 05 1120", "SSN", 100, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 6 ? 1 : 0) != 0);
        EsapiValidationTest.assertTrue((boolean)instance.isValidInput("test15", "078051120", "SSN", 100, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 6 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidInput("test16", "987-65-4320", "SSN", 100, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 7 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidInput("test17", "000-00-0000", "SSN", 100, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 8 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidInput("test18", "(555) 555-5555", "SSN", 100, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 9 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidInput("test19", "test", "SSN", 100, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 10 ? 1 : 0) != 0);
        EsapiValidationTest.assertTrue((boolean)instance.isValidInput("test20", "jeffWILLIAMS123", "HTTPParameterValue", 100, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 10 ? 1 : 0) != 0);
        EsapiValidationTest.assertTrue((boolean)instance.isValidInput("test21", "jeff .-/+=@_ WILLIAMS", "HTTPParameterValue", 100, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 10 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidInput("test22", "jeff^WILLIAMS", "HTTPParameterValue", 100, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 11 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidInput("test23", "jeff\\WILLIAMS", "HTTPParameterValue", 100, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 12 ? 1 : 0) != 0);
        EsapiValidationTest.assertTrue((boolean)instance.isValidInput("test", null, "Email", 100, true, errors));
        EsapiValidationTest.assertFalse((boolean)instance.isValidInput("test", null, "Email", 100, false, errors));
    }

    public void testIsValidInteger() {
        System.out.println("isValidInteger");
        Validator instance = ESAPI.validator();
        EsapiValidationTest.assertFalse((boolean)instance.isValidInteger("test", "-4", 1, 10, false));
        EsapiValidationTest.assertTrue((boolean)instance.isValidInteger("test", "-4", -10, 10, false));
        EsapiValidationTest.assertTrue((boolean)instance.isValidInteger("test", null, -10, 10, true));
        EsapiValidationTest.assertFalse((boolean)instance.isValidInteger("test", null, -10, 10, false));
        EsapiValidationTest.assertTrue((boolean)instance.isValidInteger("test", "", -10, 10, true));
        EsapiValidationTest.assertFalse((boolean)instance.isValidInteger("test", "", -10, 10, false));
        EsapiValidationTest.assertFalse((boolean)instance.isValidInteger("test", "50", 10, -10, false));
        EsapiValidationTest.assertFalse((boolean)instance.isValidInteger("test", "4.3214", -10, 10, true));
        EsapiValidationTest.assertFalse((boolean)instance.isValidInteger("test", "-1.65", -10, 10, true));
        EsapiValidationTest.assertTrue((boolean)instance.isValidInteger("test", "4", 1, 10, false));
        EsapiValidationTest.assertTrue((boolean)instance.isValidInteger("test", "400", 1, 10000, false));
        EsapiValidationTest.assertTrue((boolean)instance.isValidInteger("test", "400000000", 1, 400000000, false));
        EsapiValidationTest.assertFalse((boolean)instance.isValidInteger("test", "4000000000000", 1, 10000, false));
        EsapiValidationTest.assertFalse((boolean)instance.isValidInteger("test", "alsdkf", 10, 10000, false));
        EsapiValidationTest.assertFalse((boolean)instance.isValidInteger("test", "--10", 10, 10000, false));
        EsapiValidationTest.assertFalse((boolean)instance.isValidInteger("test", "14.1414234x", 10, 10000, false));
        EsapiValidationTest.assertFalse((boolean)instance.isValidInteger("test", "Infinity", 10, 10000, false));
        EsapiValidationTest.assertFalse((boolean)instance.isValidInteger("test", "-Infinity", 10, 10000, false));
        EsapiValidationTest.assertFalse((boolean)instance.isValidInteger("test", "NaN", 10, 10000, false));
        EsapiValidationTest.assertFalse((boolean)instance.isValidInteger("test", "-NaN", 10, 10000, false));
        EsapiValidationTest.assertFalse((boolean)instance.isValidInteger("test", "+NaN", 10, 10000, false));
        EsapiValidationTest.assertFalse((boolean)instance.isValidInteger("test", "1e-6", -999999999, 999999999, false));
        EsapiValidationTest.assertFalse((boolean)instance.isValidInteger("test", "-1e-6", -999999999, 999999999, false));
        ValidationErrorList errors = new ValidationErrorList();
        EsapiValidationTest.assertFalse((boolean)instance.isValidInteger("test1", "-4", 1, 10, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        EsapiValidationTest.assertTrue((boolean)instance.isValidInteger("test2", "-4", -10, 10, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        EsapiValidationTest.assertTrue((boolean)instance.isValidInteger("test3", null, -10, 10, true, errors));
        EsapiValidationTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidInteger("test4", null, -10, 10, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 2 ? 1 : 0) != 0);
        EsapiValidationTest.assertTrue((boolean)instance.isValidInteger("test5", "", -10, 10, true, errors));
        EsapiValidationTest.assertTrue((errors.size() == 2 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidInteger("test6", "", -10, 10, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 3 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidInteger("test7", "50", 10, -10, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 4 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidInteger("test8", "4.3214", -10, 10, true, errors));
        EsapiValidationTest.assertTrue((errors.size() == 5 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidInteger("test9", "-1.65", -10, 10, true, errors));
        EsapiValidationTest.assertTrue((errors.size() == 6 ? 1 : 0) != 0);
        EsapiValidationTest.assertTrue((boolean)instance.isValidInteger("test10", "4", 1, 10, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 6 ? 1 : 0) != 0);
        EsapiValidationTest.assertTrue((boolean)instance.isValidInteger("test11", "400", 1, 10000, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 6 ? 1 : 0) != 0);
        EsapiValidationTest.assertTrue((boolean)instance.isValidInteger("test12", "400000000", 1, 400000000, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 6 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidInteger("test13", "4000000000000", 1, 10000, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 7 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidInteger("test14", "alsdkf", 10, 10000, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 8 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidInteger("test15", "--10", 10, 10000, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 9 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidInteger("test16", "14.1414234x", 10, 10000, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 10 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidInteger("test17", "Infinity", 10, 10000, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 11 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidInteger("test18", "-Infinity", 10, 10000, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 12 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidInteger("test19", "NaN", 10, 10000, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 13 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidInteger("test20", "-NaN", 10, 10000, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 14 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidInteger("test21", "+NaN", 10, 10000, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 15 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidInteger("test22", "1e-6", -999999999, 999999999, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 16 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidInteger("test23", "-1e-6", -999999999, 999999999, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 17 ? 1 : 0) != 0);
    }

    public void testIsValidListItem() {
        System.out.println("isValidListItem");
        Validator instance = ESAPI.validator();
        ArrayList<String> list = new ArrayList<String>();
        list.add("one");
        list.add("two");
        EsapiValidationTest.assertTrue((boolean)instance.isValidListItem("test", "one", list));
        EsapiValidationTest.assertFalse((boolean)instance.isValidListItem("test", "three", list));
        ValidationErrorList errors = new ValidationErrorList();
        EsapiValidationTest.assertTrue((boolean)instance.isValidListItem("test1", "one", list, errors));
        EsapiValidationTest.assertTrue((errors.size() == 0 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidListItem("test2", "three", list, errors));
        EsapiValidationTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
    }

    public void testIsValidNumber() {
        System.out.println("isValidNumber");
        Validator instance = ESAPI.validator();
        EsapiValidationTest.assertFalse((boolean)instance.isValidNumber("test", "-4", 1L, 10L, false));
        EsapiValidationTest.assertTrue((boolean)instance.isValidNumber("test", "-4", -10L, 10L, false));
        EsapiValidationTest.assertTrue((boolean)instance.isValidNumber("test", null, -10L, 10L, true));
        EsapiValidationTest.assertFalse((boolean)instance.isValidNumber("test", null, -10L, 10L, false));
        EsapiValidationTest.assertTrue((boolean)instance.isValidNumber("test", "", -10L, 10L, true));
        EsapiValidationTest.assertFalse((boolean)instance.isValidNumber("test", "", -10L, 10L, false));
        EsapiValidationTest.assertFalse((boolean)instance.isValidNumber("test", "5", 10L, -10L, false));
        EsapiValidationTest.assertTrue((boolean)instance.isValidNumber("test", "4.3214", -10L, 10L, true));
        EsapiValidationTest.assertTrue((boolean)instance.isValidNumber("test", "-1.65", -10L, 10L, true));
        EsapiValidationTest.assertTrue((boolean)instance.isValidNumber("test", "4", 1L, 10L, false));
        EsapiValidationTest.assertTrue((boolean)instance.isValidNumber("test", "400", 1L, 10000L, false));
        EsapiValidationTest.assertTrue((boolean)instance.isValidNumber("test", "400000000", 1L, 400000000L, false));
        EsapiValidationTest.assertFalse((boolean)instance.isValidNumber("test", "4000000000000", 1L, 10000L, false));
        EsapiValidationTest.assertFalse((boolean)instance.isValidNumber("test", "alsdkf", 10L, 10000L, false));
        EsapiValidationTest.assertFalse((boolean)instance.isValidNumber("test", "--10", 10L, 10000L, false));
        EsapiValidationTest.assertFalse((boolean)instance.isValidNumber("test", "14.1414234x", 10L, 10000L, false));
        EsapiValidationTest.assertFalse((boolean)instance.isValidNumber("test", "Infinity", 10L, 10000L, false));
        EsapiValidationTest.assertFalse((boolean)instance.isValidNumber("test", "-Infinity", 10L, 10000L, false));
        EsapiValidationTest.assertFalse((boolean)instance.isValidNumber("test", "NaN", 10L, 10000L, false));
        EsapiValidationTest.assertFalse((boolean)instance.isValidNumber("test", "-NaN", 10L, 10000L, false));
        EsapiValidationTest.assertFalse((boolean)instance.isValidNumber("test", "+NaN", 10L, 10000L, false));
        EsapiValidationTest.assertTrue((boolean)instance.isValidNumber("test", "1e-6", -999999999L, 999999999L, false));
        EsapiValidationTest.assertTrue((boolean)instance.isValidNumber("test", "-1e-6", -999999999L, 999999999L, false));
        ValidationErrorList errors = new ValidationErrorList();
        EsapiValidationTest.assertFalse((boolean)instance.isValidNumber("test1", "-4", 1L, 10L, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        EsapiValidationTest.assertTrue((boolean)instance.isValidNumber("test2", "-4", -10L, 10L, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        EsapiValidationTest.assertTrue((boolean)instance.isValidNumber("test3", null, -10L, 10L, true, errors));
        EsapiValidationTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidNumber("test4", null, -10L, 10L, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 2 ? 1 : 0) != 0);
        EsapiValidationTest.assertTrue((boolean)instance.isValidNumber("test5", "", -10L, 10L, true, errors));
        EsapiValidationTest.assertTrue((errors.size() == 2 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidNumber("test6", "", -10L, 10L, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 3 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidNumber("test7", "5", 10L, -10L, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 4 ? 1 : 0) != 0);
        EsapiValidationTest.assertTrue((boolean)instance.isValidNumber("test8", "4.3214", -10L, 10L, true, errors));
        EsapiValidationTest.assertTrue((errors.size() == 4 ? 1 : 0) != 0);
        EsapiValidationTest.assertTrue((boolean)instance.isValidNumber("test9", "-1.65", -10L, 10L, true, errors));
        EsapiValidationTest.assertTrue((errors.size() == 4 ? 1 : 0) != 0);
        EsapiValidationTest.assertTrue((boolean)instance.isValidNumber("test10", "4", 1L, 10L, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 4 ? 1 : 0) != 0);
        EsapiValidationTest.assertTrue((boolean)instance.isValidNumber("test11", "400", 1L, 10000L, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 4 ? 1 : 0) != 0);
        EsapiValidationTest.assertTrue((boolean)instance.isValidNumber("test12", "400000000", 1L, 400000000L, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 4 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidNumber("test13", "4000000000000", 1L, 10000L, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 5 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidNumber("test14", "alsdkf", 10L, 10000L, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 6 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidNumber("test15", "--10", 10L, 10000L, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 7 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidNumber("test16", "14.1414234x", 10L, 10000L, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 8 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidNumber("test17", "Infinity", 10L, 10000L, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 9 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidNumber("test18", "-Infinity", 10L, 10000L, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 10 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidNumber("test19", "NaN", 10L, 10000L, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 11 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidNumber("test20", "-NaN", 10L, 10000L, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 12 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidNumber("test21", "+NaN", 10L, 10000L, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 13 ? 1 : 0) != 0);
        EsapiValidationTest.assertTrue((boolean)instance.isValidNumber("test22", "1e-6", -999999999L, 999999999L, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 13 ? 1 : 0) != 0);
        EsapiValidationTest.assertTrue((boolean)instance.isValidNumber("test23", "-1e-6", -999999999L, 999999999L, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 13 ? 1 : 0) != 0);
    }

    public void testIsValidParameterSet() {
        System.out.println("isValidParameterSet");
        HashSet<String> requiredNames = new HashSet<String>();
        requiredNames.add("p1");
        requiredNames.add("p2");
        requiredNames.add("p3");
        HashSet<String> optionalNames = new HashSet<String>();
        optionalNames.add("p4");
        optionalNames.add("p5");
        optionalNames.add("p6");
    }

    public void testIsValidPrintable() {
        System.out.println("isValidPrintable");
        Validator instance = ESAPI.validator();
        EsapiValidationTest.assertTrue((boolean)instance.isValidPrintable("name", "abcDEF", 100, false));
        EsapiValidationTest.assertTrue((boolean)instance.isValidPrintable("name", "!@#R()*$;><()", 100, false));
        char[] chars = new char[]{'`', '\u00ff', '\u0010', '%'};
        EsapiValidationTest.assertFalse((boolean)instance.isValidPrintable("name", chars, 100, false));
        EsapiValidationTest.assertFalse((boolean)instance.isValidPrintable("name", "%08", 100, false));
        ValidationErrorList errors = new ValidationErrorList();
        EsapiValidationTest.assertTrue((boolean)instance.isValidPrintable("name1", "abcDEF", 100, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 0 ? 1 : 0) != 0);
        EsapiValidationTest.assertTrue((boolean)instance.isValidPrintable("name2", "!@#R()*$;><()", 100, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 0 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidPrintable("name3", chars, 100, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        EsapiValidationTest.assertFalse((boolean)instance.isValidPrintable("name4", "%08", 100, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 2 ? 1 : 0) != 0);
    }

    public void testIsValidRedirectLocation() {
    }

    public void testIsValidSafeHTML() {
        System.out.println("isValidSafeHTML");
        Validator instance = ESAPI.validator();
        EsapiValidationTest.assertTrue((boolean)instance.isValidSafeHTML("test", "<b>Jeff</b>", 100, false));
        EsapiValidationTest.assertTrue((boolean)instance.isValidSafeHTML("test", "<a href=\"http://www.aspectsecurity.com\">Aspect Security</a>", 100, false));
        EsapiValidationTest.assertTrue((boolean)instance.isValidSafeHTML("test", "Test. <script>alert(document.cookie)</script>", 100, false));
        EsapiValidationTest.assertTrue((boolean)instance.isValidSafeHTML("test", "Test. <div style={xss:expression(xss)}>", 100, false));
        EsapiValidationTest.assertTrue((boolean)instance.isValidSafeHTML("test", "Test. <s%00cript>alert(document.cookie)</script>", 100, false));
        EsapiValidationTest.assertTrue((boolean)instance.isValidSafeHTML("test", "Test. <s\tcript>alert(document.cookie)</script>", 100, false));
        EsapiValidationTest.assertTrue((boolean)instance.isValidSafeHTML("test", "Test. <s\r\n\u0000cript>alert(document.cookie)</script>", 100, false));
        ValidationErrorList errors = new ValidationErrorList();
        EsapiValidationTest.assertTrue((boolean)instance.isValidSafeHTML("test1", "<b>Jeff</b>", 100, false, errors));
        EsapiValidationTest.assertTrue((boolean)instance.isValidSafeHTML("test2", "<a href=\"http://www.aspectsecurity.com\">Aspect Security</a>", 100, false, errors));
        EsapiValidationTest.assertTrue((boolean)instance.isValidSafeHTML("test3", "Test. <script>alert(document.cookie)</script>", 100, false, errors));
        EsapiValidationTest.assertTrue((boolean)instance.isValidSafeHTML("test4", "Test. <div style={xss:expression(xss)}>", 100, false, errors));
        EsapiValidationTest.assertTrue((boolean)instance.isValidSafeHTML("test5", "Test. <s%00cript>alert(document.cookie)</script>", 100, false, errors));
        EsapiValidationTest.assertTrue((boolean)instance.isValidSafeHTML("test6", "Test. <s\tcript>alert(document.cookie)</script>", 100, false, errors));
        EsapiValidationTest.assertTrue((boolean)instance.isValidSafeHTML("test7", "Test. <s\r\n\u0000cript>alert(document.cookie)</script>", 100, false, errors));
        EsapiValidationTest.assertTrue((errors.size() == 0 ? 1 : 0) != 0);
    }

    public void testSafeReadLine() {
        System.out.println("safeReadLine");
        byte[] bytes = null;
        try {
            bytes = "testString".getBytes(PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException e1) {
            EsapiValidationTest.fail((String)"UTF-8 not a supported encoding?!?!!!");
        }
        ByteArrayInputStream s = new ByteArrayInputStream(bytes);
        Validator instance = ESAPI.validator();
        try {
            instance.safeReadLine((InputStream)s, -1);
            EsapiValidationTest.fail();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        s.reset();
        try {
            instance.safeReadLine((InputStream)s, 4);
            EsapiValidationTest.fail();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        s.reset();
        try {
            String u = instance.safeReadLine((InputStream)s, 20);
            EsapiValidationTest.assertEquals((String)"testString", (String)u);
        }
        catch (ValidationException e) {
            EsapiValidationTest.fail();
        }
        try {
            s.reset();
            InputStreamReader isr = new InputStreamReader(s);
            BufferedReader br = new BufferedReader(isr);
            String u = br.readLine();
            s.reset();
            String v = instance.safeReadLine((InputStream)s, 20);
            EsapiValidationTest.assertEquals((String)u, (String)v);
        }
        catch (IOException e) {
            EsapiValidationTest.fail();
        }
        catch (ValidationException e) {
            EsapiValidationTest.fail();
        }
    }

    public void testIssue82_SafeString_Bad_Regex() {
        Validator instance = ESAPI.validator();
        try {
            instance.getValidInput("address", "55 main st. pasadena ak", "SafeString", 512, false);
        }
        catch (ValidationException e) {
            EsapiValidationTest.fail((String)e.getLogMessage());
        }
    }

    public void testGetParameterMap() {
    }

    public void testGetParameterNames() {
    }

    public void testGetParameter() {
    }

    public void testGetCookies() {
    }

    public void testGetHeader() {
    }

    public void testGetHeaderNames() {
    }

    public void testGetQueryString() {
    }

    public void testGetRequestURI() {
    }

    private String generateStringOfLength(int length) {
        StringBuilder longString = new StringBuilder();
        int i = 0;
        while (i < length) {
            longString.append("a");
            ++i;
        }
        return longString.toString();
    }
}

