/*
 * Decompiled with CFR 0.152.
 */
package ch.security4web.esapi.validator;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.ValidationErrorList;
import org.owasp.esapi.ValidationRule;
import org.owasp.esapi.Validator;
import org.owasp.esapi.reference.validation.HTMLValidationRule;

public class EsapiTestCase
extends TestCase {
    private static final String PREFERRED_ENCODING = "UTF-8";

    public static Test suite() {
        return new TestSuite(EsapiTestCase.class);
    }

    public EsapiTestCase(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public void testGetValidSafeHTML() throws Exception {
        System.out.println("getValidSafeHTML");
        Validator instance = ESAPI.validator();
        ValidationErrorList errors = new ValidationErrorList();
        HTMLValidationRule rule = new HTMLValidationRule("test");
        ESAPI.validator().addRule((ValidationRule)rule);
        EsapiTestCase.assertEquals((Object)"Test.", (Object)ESAPI.validator().getRule("test").getValid("test", "Test. <script>alert(document.cookie)</script>"));
        String test1 = "<b>Jeff</b>";
        String result1 = instance.getValidSafeHTML("test", test1, 100, false, errors);
        EsapiTestCase.assertEquals((String)test1, (String)result1);
        String test2 = "<a href=\"http://www.aspectsecurity.com\">Aspect Security</a>";
        String result2 = instance.getValidSafeHTML("test", test2, 100, false, errors);
        EsapiTestCase.assertEquals((String)test2, (String)result2);
        String test3 = "Test. <script>alert(document.cookie)</script>";
        EsapiTestCase.assertEquals((Object)"Test.", (Object)rule.getSafe("test", test3));
        EsapiTestCase.assertEquals((Object)"Test. &lt;<div>load=alert()</div>", (Object)rule.getSafe("test", "Test. <<div on<script></script>load=alert()"));
        EsapiTestCase.assertEquals((Object)"Test. <div>b</div>", (Object)rule.getSafe("test", "Test. <div style={xss:expression(xss)}>b</div>"));
        EsapiTestCase.assertEquals((Object)"Test.", (Object)rule.getSafe("test", "Test. <s%00cript>alert(document.cookie)</script>"));
        EsapiTestCase.assertEquals((Object)"Test. alert(document.cookie)", (Object)rule.getSafe("test", "Test. <s\tcript>alert(document.cookie)</script>"));
        EsapiTestCase.assertEquals((Object)"Test. alert(document.cookie)", (Object)rule.getSafe("test", "Test. <s\tcript>alert(document.cookie)</script>"));
    }
}

