/*
 * Decompiled with CFR 0.152.
 */
package ch.security4web.esapi.validator;

import java.io.File;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.ValidationErrorList;
import org.owasp.esapi.ValidationRule;
import org.owasp.esapi.Validator;
import org.owasp.esapi.reference.validation.HTMLValidationRule;

public class EsapiTestValidation {
    public static void main(String[] args) {
        try {
            System.out.println("getValidSafeHTML");
            Validator instance = ESAPI.validator();
            ValidationErrorList errors = new ValidationErrorList();
            HTMLValidationRule rule = new HTMLValidationRule("test");
            ESAPI.validator().addRule((ValidationRule)rule);
            System.out.println(ESAPI.validator().getRule("test").getValid("test", "Test. <script>alert(document.cookie)</script>"));
            String test1 = "<b>Jeff</b>";
            String result1 = instance.getValidSafeHTML("test", test1, 100, false, errors);
            System.out.println("Test-1 :-" + result1);
            String test2 = "<input type=\"text\" name=\"lname\" />";
            String result2 = instance.getValidSafeHTML("test", test2, 100, false, errors);
            System.out.println("Test-2 :-" + result2);
            String test21 = "<a href=\"http://www.aspectsecurity.com\">Aspect Security</a> 4";
            String result21 = instance.getValidSafeHTML("test", test21, 100, false, errors);
            System.out.println("Test-21 :-" + result21);
            String test3 = "Test. <script>alert(document.cookie)</script>";
            System.out.println("Test-3 :-" + rule.getSafe("test", test3));
            System.out.println("Test-4 :-" + rule.getSafe("test", "Test. <<div on<script></script>load=alert()"));
            System.out.println("Test-5 :-" + rule.getSafe("test", "Test. <div style={xss:expression(xss)}>b</div>"));
            System.out.println("Test-6 :-" + rule.getSafe("test", "Test. <s%00cript>alert(document.cookie)</script>"));
            System.out.println("Test-7 :-" + rule.getSafe("test", "Test. <s\tcript>alert(document.cookie)</script>"));
            System.out.println("Test-8 :-" + rule.getSafe("test", "Test. <s\tcript>alert(document.cookie)</script>"));
            System.out.println("Test-9 :-" + rule.getSafe("test", "Test. <input type='text' value='better' />"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void testIsInvalidFilename() {
        Validator instance = ESAPI.validator();
        System.out.println(instance.isValidInput("test", "jeff.williams@aspectsecurity.com", "Email", 100, false));
        System.out.println(instance.isValidInput("test", "jeff.williams@@aspectsecurity.com", "Email", 100, false));
        System.out.println(instance.isValidInput("test", "jeff.williams@aspectsecurity", "Email", 100, false));
        System.out.println(instance.isValidInput("test", "jeff.wil'liams@aspectsecurity.com", "Email", 100, false));
        System.out.println(instance.isValidInput("test", "jeff.wil''liams@aspectsecurity.com", "Email", 100, false));
    }

    public static void testGetValidDirectoryPath() {
        try {
            System.out.println("getValidDirectoryPath");
            Validator instance = ESAPI.validator();
            ValidationErrorList errors = new ValidationErrorList();
            File parent = new File("/4545666");
            String path = ESAPI.securityConfiguration().getResourceFile("ESAPI.properties").getParentFile().getCanonicalPath();
            System.out.println(instance.getValidDirectoryPath("dirtest1", path, parent, true, errors));
            System.out.println(instance.getValidDirectoryPath("dirtest2", null, parent, false, errors));
            System.out.println(instance.getValidDirectoryPath("dirtest3", "ridicul%00ous", parent, false, errors));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void testLenientDate() {
        DateFormat shortDf = DateFormat.getDateInstance(3);
        DateFormat mediumDf = DateFormat.getDateInstance(2);
        DateFormat longDf = DateFormat.getDateInstance(1);
        DateFormat fullDf = DateFormat.getDateInstance(0);
        System.out.println(shortDf.format(new Date()));
        System.out.println(mediumDf.format(new Date()));
        System.out.println(longDf.format(new Date()));
        System.out.println(fullDf.format(new Date()));
        try {
            Date date = shortDf.parse("1/1/2005");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        System.out.println("testLenientDate");
        boolean acceptLenientDates = ESAPI.securityConfiguration().getLenientDatesAccepted();
        if (acceptLenientDates) {
            return;
        }
        Date lenientDateTest = null;
        try {
            Validator instance = ESAPI.validator();
            lenientDateTest = instance.getValidDate("datatest3-lenient", "2/28/2009", DateFormat.getDateInstance(3), false);
            System.out.println("Test Vale:" + lenientDateTest);
        }
        catch (Exception ve) {
            ve.printStackTrace();
        }
    }
}

