/*
 * Decompiled with CFR 0.152.
 */
package ch.security4web.esapi.validator;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.ValidatorException;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.ValidationErrorList;
import org.owasp.esapi.ValidationRule;
import org.owasp.esapi.Validator;
import org.owasp.esapi.errors.ValidationException;
import org.owasp.esapi.reference.validation.HTMLValidationRule;

@FacesValidator(value="esapiValidator")
public class EsapiValidator
implements javax.faces.validator.Validator {
    private String name;
    private String format;
    private String encoding;

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        String textValue = (String)value;
        if (this.name != null && this.name.toUpperCase().equals("DATE")) {
            Boolean flag = this.isValidateDate(textValue);
            if (flag == null || !flag.booleanValue()) {
                FacesMessage msg = new FacesMessage("Date validation failed.", "Invalid Date format.");
                msg.setSeverity(FacesMessage.SEVERITY_ERROR);
                throw new ValidatorException(msg);
            }
        } else if (this.name != null && this.name.toUpperCase().equals("CREDITCARD")) {
            Boolean flag = this.isValidateCreditCard(textValue);
            if (flag == null || flag.booleanValue()) {
                FacesMessage msg = new FacesMessage("Credit Card validation failed.", "Invalid Credit Card format.");
                msg.setSeverity(FacesMessage.SEVERITY_ERROR);
                throw new ValidatorException(msg);
            }
        } else {
            if (this.name != null && this.name.toUpperCase().equals("HTMLVALIDATION")) {
                if (textValue != null && !textValue.trim().equals("")) {
                    try {
                        String validHtml = this.getValidHtmlOutput(component, textValue);
                    }
                    catch (Exception exception) {
                        FacesMessage msg = new FacesMessage("Html validation failed.", "Html validation error.");
                        msg.setSeverity(FacesMessage.SEVERITY_ERROR);
                        throw new ValidatorException(msg);
                    }
                }
                FacesMessage msg = new FacesMessage("Html validation failed.", "Enter Value.");
                msg.setSeverity(FacesMessage.SEVERITY_ERROR);
                throw new ValidatorException(msg);
            }
            if (this.name != null && this.name.toUpperCase().equals("LENIENTDATE")) {
                if (textValue != null && !textValue.trim().equals("")) {
                    try {
                        this.checkLenientDate(context, component, textValue);
                    }
                    catch (Exception exception) {
                        ((UIInput)component).setValid(false);
                        FacesMessage msg = new FacesMessage("Invalidation Date Format");
                        context.addMessage(component.getClientId(), msg);
                    }
                } else {
                    ((UIInput)component).setValid(false);
                    FacesMessage msg = new FacesMessage("Enter Date.");
                    context.addMessage(component.getClientId(), msg);
                }
            } else if (this.name != null && this.name.toUpperCase().equals("FILE")) {
                if (textValue != null && !textValue.trim().equals("")) {
                    try {
                        this.checkFileValidation(textValue);
                    }
                    catch (Exception e) {
                        ((UIInput)component).setValid(false);
                        FacesMessage msg = new FacesMessage("Invalidation File Path");
                        context.addMessage(component.getClientId(), msg);
                    }
                } else {
                    ((UIInput)component).setValid(false);
                    FacesMessage msg = new FacesMessage("Enter File Name.");
                    context.addMessage(component.getClientId(), msg);
                }
            } else if (this.name != null && this.name.toUpperCase().equals("FILECONTENT")) {
                if (textValue != null && !textValue.trim().equals("")) {
                    if (this.encoding != null && !this.encoding.trim().equals("")) {
                        try {
                            this.valideFileContent(context, component, textValue);
                        }
                        catch (Exception e) {
                            ((UIInput)component).setValid(false);
                            FacesMessage msg = new FacesMessage("Invalidation File Content");
                            context.addMessage(component.getClientId(), msg);
                        }
                    } else {
                        ((UIInput)component).setValid(false);
                        FacesMessage msg = new FacesMessage("Invalid Encoding.");
                        context.addMessage(component.getClientId(), msg);
                    }
                } else {
                    ((UIInput)component).setValid(false);
                    FacesMessage msg = new FacesMessage("Enter File Name.");
                    context.addMessage(component.getClientId(), msg);
                }
            } else if (this.name != null && this.name.toUpperCase().equals("VALIDFILENAME")) {
                if (textValue != null && !textValue.trim().equals("")) {
                    try {
                        int size = this.validFileName(textValue);
                        if (size > 0) {
                            ((UIInput)component).setValid(false);
                            FacesMessage msg = new FacesMessage("Invalidation File Content");
                            context.addMessage(component.getClientId(), msg);
                        }
                    }
                    catch (Exception e) {
                        ((UIInput)component).setValid(false);
                        FacesMessage msg = new FacesMessage("Invalidation File Content");
                        context.addMessage(component.getClientId(), msg);
                    }
                } else {
                    ((UIInput)component).setValid(false);
                    FacesMessage msg = new FacesMessage("Enter File Name.");
                    context.addMessage(component.getClientId(), msg);
                }
            } else if (this.name != null && this.name.toUpperCase().equals("EMAIL")) {
                if (textValue != null && !textValue.trim().equals("")) {
                    try {
                        Validator instance = ESAPI.validator();
                        boolean flag = instance.isValidInput("test", textValue, "Email", 100, false);
                        if (!flag) {
                            ((UIInput)component).setValid(false);
                            FacesMessage msg = new FacesMessage("Invalidation Email Format.");
                            context.addMessage(component.getClientId(), msg);
                        }
                    }
                    catch (Exception e) {
                        ((UIInput)component).setValid(false);
                        FacesMessage msg = new FacesMessage("Invalidation Email Format.");
                        context.addMessage(component.getClientId(), msg);
                    }
                } else {
                    ((UIInput)component).setValid(false);
                    FacesMessage msg = new FacesMessage("Enter Email Id.");
                    context.addMessage(component.getClientId(), msg);
                }
            } else if (this.name != null && this.name.toUpperCase().equals("IPADDRESS")) {
                if (textValue != null && !textValue.trim().equals("")) {
                    try {
                        Validator instance = ESAPI.validator();
                        boolean flag = instance.isValidInput("test", textValue, "IPAddress", 100, false);
                        if (!flag) {
                            ((UIInput)component).setValid(false);
                            FacesMessage msg = new FacesMessage("Invalidation IPaddress Format.");
                            context.addMessage(component.getClientId(), msg);
                        }
                    }
                    catch (Exception e) {
                        ((UIInput)component).setValid(false);
                        FacesMessage msg = new FacesMessage("Invalidation IPaddress Format.");
                        context.addMessage(component.getClientId(), msg);
                    }
                } else {
                    ((UIInput)component).setValid(false);
                    FacesMessage msg = new FacesMessage("Enter IPaddress.");
                    context.addMessage(component.getClientId(), msg);
                }
            } else if (this.name != null && this.name.toUpperCase().equals("URL")) {
                if (textValue != null && !textValue.trim().equals("")) {
                    try {
                        Validator instance = ESAPI.validator();
                        boolean flag = instance.isValidInput("test", textValue, "URL", 100, false);
                        if (!flag) {
                            ((UIInput)component).setValid(false);
                            FacesMessage msg = new FacesMessage("Invalidation URL.");
                            context.addMessage(component.getClientId(), msg);
                        }
                    }
                    catch (Exception e) {
                        ((UIInput)component).setValid(false);
                        FacesMessage msg = new FacesMessage("Invalidation URL.");
                        context.addMessage(component.getClientId(), msg);
                    }
                } else {
                    ((UIInput)component).setValid(false);
                    FacesMessage msg = new FacesMessage("Enter URL.");
                    context.addMessage(component.getClientId(), msg);
                }
            } else if (this.name != null && this.name.toUpperCase().equals("SSNVALIDATION")) {
                if (textValue != null && !textValue.trim().equals("")) {
                    try {
                        Validator instance = ESAPI.validator();
                        boolean flag = instance.isValidInput("test", textValue, "SSN", 100, false);
                        if (!flag) {
                            ((UIInput)component).setValid(false);
                            FacesMessage msg = new FacesMessage("Invalidation SSN.");
                            context.addMessage(component.getClientId(), msg);
                        }
                    }
                    catch (Exception e) {
                        ((UIInput)component).setValid(false);
                        FacesMessage msg = new FacesMessage("Invalidation SSN.");
                        context.addMessage(component.getClientId(), msg);
                    }
                } else {
                    ((UIInput)component).setValid(false);
                    FacesMessage msg = new FacesMessage("Enter SSN.");
                    context.addMessage(component.getClientId(), msg);
                }
            } else {
                FacesMessage msg = new FacesMessage("HTML validation failed.", "Enter TextField Value.");
                msg.setSeverity(FacesMessage.SEVERITY_ERROR);
                throw new ValidatorException(msg);
            }
        }
    }

    private int validFileName(String textValue) {
        Validator instance = ESAPI.validator();
        ValidationErrorList errors = new ValidationErrorList();
        instance.getValidFileName("test", textValue, ESAPI.securityConfiguration().getAllowedFileExtensions(), false, errors);
        return errors.size();
    }

    private void valideFileContent(FacesContext context, UIComponent component, String textValue) {
        Validator instance = ESAPI.validator();
        ValidationErrorList errors = new ValidationErrorList();
        byte[] bytes = null;
        try {
            bytes = "12345".getBytes(this.encoding);
        }
        catch (Exception e) {
            ((UIInput)component).setValid(false);
            FacesMessage msg = new FacesMessage("Invalidation File Encoding");
            context.addMessage(component.getClientId(), msg);
        }
    }

    private void checkFileValidation(String textValue) throws Exception {
        Validator instance = ESAPI.validator();
        ValidationErrorList errors = new ValidationErrorList();
        File parent = new File(textValue);
        String path = ESAPI.securityConfiguration().getResourceFile("ESAPI.properties").getParentFile().getCanonicalPath();
        instance.getValidDirectoryPath("dirtest1", path, parent, true, errors);
    }

    private void checkLenientDate(FacesContext context, UIComponent component, String textValue) {
        boolean acceptLenientDates = ESAPI.securityConfiguration().getLenientDatesAccepted();
        if (acceptLenientDates) {
            return;
        }
        Date lenientDateTest = null;
        try {
            Validator instance = ESAPI.validator();
            if (this.format.trim().equals("SHORT")) {
                lenientDateTest = instance.getValidDate("datatest3-lenient", textValue, DateFormat.getDateInstance(3, Locale.US), false);
            } else if (this.format.equals("MEDIUM")) {
                lenientDateTest = instance.getValidDate("datatest3-lenient", textValue, DateFormat.getDateInstance(2, Locale.US), false);
            } else if (this.format.equals("LONG")) {
                lenientDateTest = instance.getValidDate("datatest3-lenient", textValue, DateFormat.getDateInstance(1, Locale.US), false);
            } else if (this.format.equals("FULL")) {
                lenientDateTest = instance.getValidDate("datatest3-lenient", textValue, DateFormat.getDateInstance(0, Locale.US), false);
            } else {
                ((UIInput)component).setValid(false);
                FacesMessage msg = new FacesMessage("Invalidation Date Format");
                context.addMessage(component.getClientId(), msg);
            }
        }
        catch (Exception e) {
            ((UIInput)component).setValid(false);
            FacesMessage msg = new FacesMessage("Invalidation Date Format");
            context.addMessage(component.getClientId(), msg);
        }
    }

    private boolean isValidateDate(String textValue) throws ValidatorException {
        Boolean flag = null;
        if (textValue == null || textValue.trim().equals("")) {
            FacesMessage msg = new FacesMessage("Date validation failed.", "Null Input Value.");
            msg.setSeverity(FacesMessage.SEVERITY_ERROR);
            throw new ValidatorException(msg);
        }
        Validator instance = ESAPI.validator();
        DateFormat format = SimpleDateFormat.getDateInstance();
        flag = instance.isValidDate("datetest1", textValue, format, true);
        return flag;
    }

    private boolean isValidateCreditCard(String textValue) throws ValidatorException {
        Boolean flag = null;
        if (textValue == null || textValue.trim().equals("")) {
            FacesMessage msg = new FacesMessage("Credit Card validation failed.", "Enter Credit Card Number.");
            msg.setSeverity(FacesMessage.SEVERITY_ERROR);
            throw new ValidatorException(msg);
        }
        Validator instance = ESAPI.validator();
        flag = !instance.isValidCreditCard("cctest1", textValue, true);
        return flag;
    }

    private String getValidHtmlOutput(UIComponent component, String textValue) throws ValidationException {
        Validator instance = ESAPI.validator();
        ValidationErrorList errors = new ValidationErrorList();
        HTMLValidationRule rule = new HTMLValidationRule("test");
        ESAPI.validator().addRule((ValidationRule)rule);
        String filteredTextValue = (String)ESAPI.validator().getRule("test").getValid("test", textValue);
        System.out.println("********** Filtered Value :" + filteredTextValue);
        System.out.println("********** Get Class :" + component.getClass());
        return filteredTextValue;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

